program KDRPatch;

{ Contains patch information for versions of Keen Dreams }
{ Written by Brian Rodgers and David Gow.  Requires Keen }
{ Dreams v1.13. UNLZEXE OPTIONAL. Support level.name     }

{$A+,B+,E-,F-,G-,I-,P+,Q-,R-,S-,T-,V-,X+}
{$M 2304,0,0}

{$DEFINE KEEND}
{$DEFINE KEEN4_ARCH}

uses Loader,Parser,Patcher,Misc,Dos,Strings;

const
    { The search pattern to use when looking for the game executable }
    ExecutableFileSpec='KDREAMS*.EXE';

    { The name of the CKPatch program for this episode }
    ProgramName='KDRPATCH';

    { The extension that the game uses }
    Ext='KDR';

    { Number of levels featured in this game }
    NumLevels=16;

type
    { Enumerations for each of the resources }
    TDataResource=(
        drAudioHed, { AUDIOHED, index of sound effects in AUDIO.KDR }
        drEGAHead,  { EGAHEAD, index of sprite tiles in EGAGRAPH.KDR }
        drMapHead,  { MAPHEAD, index of levels in GAMEMAPS.KDR }
        drAudioDct, { AUDIODCT, huffman tree for decompressing AUDIO.KDR }
        drEGADict   { EGADICT, huffman tree for decompressing EGAGRAPH.KDR }
        );

    { Contains image offsets of each resource }
    PDataResourceOffset=^TDataResourceOffset;
    TDataResourceOffset=
        array[Low(TDataResource)..High(TDataResource)] of Longint;

    { Contains byte lengths of each resource }
    PDataResourceLength=^TDataResourceLength;
    TDataResourceLength=
        array[Low(TDataResource)..High(TDataResource)] of Longint;

    { Contains the maximum length of the name of each level }
    PLevelStringLength=^TLevelStringLength;
    TLevelStringLength=array[0..NumLevels] of Word;

    { The version information structure for Keen 5 }
    PVersion=^TVersion;
    TVersion=record
        { The version ID string }
        ID:String[7];

        { The uncompressed length of the game executable image }
        ImageLength:Longint;

        { The LZEXE-compressed length of the game executable image }
        LZEXEImageLength:Longint;

        { Image offsets of each of the data resources }
        DataResourceOffset:PDataResourceOffset;

        { Byte lengths of each of the data resources }
        DataResourceLength:PDataResourceLength;

        { Image offset of the level name string array }
        LevelNameOffset:Longint;

        { Maximum lengths of each of the level name strings }
        LevelNameLength:PLevelStringLength;

        { Image offset of the level entry string array }
        LevelEntryOffset:Longint;

        { Maximum lengths of each of the level entry strings }
        LevelEntryLength:PLevelStringLength;
    end;

const
    { Resource image offsets for version 1.4 }
    DataResourceOffset_14:TDataResourceOffset=
        ($21C78,$!CB20,$1FA50,$35EC4,$2A042);

    { Resource byte lengths for version 1.4 }
    DataResourceLength_14:TDataResourceLength=
        (840,$2F30,$192,1024,1024);

    { Level name maximum lengths for version 1.4 }
    LevelNameLength_14:TLevelStringLength=
        (20,17,16,16,16,14,8,11,8,12,12,9,20,9,13,16,15);

    { Level entry name maximum lengths for version 1.4 }
    LevelEntryLength_14:TLevelStringLength=
        (48,48,48,48,48,48,48,48,48,48,48,64,48,48,48,64,48);

    { Versions currently supported are 1.4 }
    Version:array[0..0] of TVersion=(
        (
            { Keen 5 version 1.4 }
            ID:'1.31';
            ImageLength:206368;
            LZEXEImageLength:81587;
            DataResourceOffset:@DataResourceOffset_14;
            DataResourceLength:@DataResourceLength_14;
            LevelNameOffset:$23FCA;
            LevelNameLength:@LevelNameLength_14;
            LevelEntryOffset:$201F0;
            LevelEntryLength:@LevelEntryLength_14
        ));

{$I CKXPATCH.INC}

begin
    Main;
end.
