#!/bin/bash

# Are we running 32 or 64 bit Linux?

MACHINE=`uname -m`
if [ "$MACHINE" = "x86_64" ]
then
	# Set path to binary (64 bit)
	SDL2BIN="../handmade/code/sdl2-64/bin/sdl2-config"
	SDL2RPATH='$ORIGIN/../handmade/code/sdl2-64/lib'
else
	# Default to x86. If it's not x86, it might be able to emulate it.
	SDL2BIN="../handmade/code/sdl2-32/bin/sdl2-config"
	SDL2RPATH='$ORIGIN/../handmade/code/sdl2-64/lib'
fi

mkdir -p ../../build
pushd ../../build
c++ -DHANDMADE_SDL=1 ../handmade/code/sdl_handmade_queueaudio.cpp -o handmadehero -g `$SDL2BIN --cflags --libs` -Wl,-rpath=$SDL2RPATH
popd

