#!/bin/bash
mkdir -p ../../build
pushd ../../build
CommonFlags="-Wall -Werror -Wno-write-strings -Wno-unused-variable -fno-rtti -fno-exceptions -DHANDMADE_INTERNAL=1 -DHANDMADE_SLOW=1 -DHANDMADE_SDL=1"
# Build a 64-bit version
c++ $CommonFlags ../handmade/code/sdl_handmade.cpp -o handmadehero.x86_64 -g `../handmade/code/sdl2-64/bin/sdl2-config --cflags --libs` -Wl,-rpath,'$ORIGIN/x86_64'
# Build a 32-bit version
c++ -m32 $CommonFlags ../handmade/code/sdl_handmade.cpp -o handmadehero.x86 -g `../handmade/code/sdl2-32/bin/sdl2-config --cflags --libs` -Wl,-rpath,'$ORIGIN/x86'

#Copy SDL into the right directory.
mkdir -p x86_64
cp ../handmade/code/sdl2-64/lib/libSDL2-2.0.so.0 x86_64/
mkdir -p x86
cp ../handmade/code/sdl2-32/lib/libSDL2-2.0.so.0 x86/
popd

